% Model of a nonisothermal batch reactor - Alkylation
%                                          Two reactions

% Function file

% For more information, see:

% A. De Visscher 
% Lecture Notes in Chemical Engineering Kinetics and Chemical Reactor Design
% Createspace (2013) 

% (C) Alex De Visscher (2013)

% ---------------------------

function dcdt = f(t,c,A,EA,B,H,V,m,Ac,U,Tc,ws,DH0,CpiC4,CpC4,CpiC8,CpiC12,DCp)

dcdt = zeros(5,1);     % Allocate space for the right-hand sides of the DEs

cC4 = c(1);                  % Butene concentration
ciC4 = c(2);                 % Isobutane concentration
ciC8 = c(3);                 % Isooctane concentration
ciC12 = c(4);                % Isododecane concentration
T = c(5);                    % Temperature

R = 8.314472;
k1 = A*exp(-EA/(R*T));       % Rate constants
K = B*exp(H/(R*T));
r1 = k1*cC4*ciC4/(ciC4 + ciC8 + K*cC4); % Reaction rate 1
r2 = k1*cC4*ciC8/(ciC4 + ciC8 + K*cC4); % Reaction rate 2

DH = DH0 + DCp*(T - 298.15);
q = U*Ac*(Tc - T);
Cpsum = V*(cC4*CpiC4 + ciC4*CpiC4 + ciC8*CpiC8 + ciC12*CpiC12);

dcdt(1) = -m*(r1 + r2)/V;        % Differential equations for concentration
dcdt(2) = -m*r1/V;
dcdt(3) = m*(r1 - r2)/V;
dcdt(4) = m*r2/V;
dcdt(5) = (-m*(r1 + r2)*DH + ws + q)/Cpsum;
